@extends('layouts.guest')

@section('title', 'Account Login')
@section('content')

<section class=" auth">
        <div class="container">
            <div class="pb-3 row justify-content-center">

                <div class="col-12 col-md-6 col-lg-6 col-sm-10 col-xl-6">
                    <div class="text-center mb-3">
                       <a href="/"><img src="{{ asset('storage/app/public/' . $settings->logo) }}" alt="" class="mb-3 img-fluid" width="40%"></a> 
                    </div>
                    
                                                                        <div class="card login-page roundedd border-1 ">
                        <div class="card-body">
                            <h4 class="text-center card-title text-white mb-1">Welcome Back</h4>
                            <p class="text-center" style="color:white;opacity:0.5">Please login to continue</p>
                                @if (Session::has('status'))
                                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                        {{ session('status') }}
                                        <button type="button" class="close" data-dismiss="alert"
                                            aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                @endif
                                @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <button type="button" class="text-white close" data-dismiss="alert"
                                            aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                            <form method="POST" action="{{ route('login') }}" class="mt-4 login-form">
                                        @csrf
                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <!--<label class="text-white">Email</label>-->
                                            <div class="position-relative">
                                                <input type="email" class="form-control" name="email" value="{{ old('email') }}" id="email" placeholder="Enter Email" required="">
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <div class="col-lg-12">
                                        <div class="form-group">
                                            <!--<label class="text-white">Password</label>-->
                                            <div class="position-relative">
                                                <!--<i data-feather="lock" class="fea icon-sm icons" style="color:rgba(255,255,255,0.3)"></i>-->
                                                <input type="password" class="form-control" name="password" id="password" placeholder="Enter Password" required="">
                                            </div>
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <div class="col-lg-12">
                                        <div class="d-flex justify-content-between">
                                            <div class="form-group">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" id="customCheck1" name="remember">
                                                    <label class="custom-control-label" for="customCheck1" style="color:rgba(255,255,255,0.5); font-weight:400">Remember
                                                        me</label>
                                                </div>
                                            </div>
                                            <p class="mb-0 forgot-pass"><a href="{{ route('password.request') }}" style="color:rgba(255,255,255,0.5); font-weight:400">Forgot password ?</a></p>
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <div class="mb-0 col-lg-12">
                                        <button class="btn btn-primary btn-block pad" name="login" type="submit">Log In</button>
                                    </div>
                                    <!--end col-->

                                    <div class="mt-4 text-center col-lg-12">
                                                                            </div>
                                    <!--end col-->
                                    <!--end col-->

                                    <div class="text-center col-12">
                                        <p class="mt-0 mb-0"><a href="{{ route('register') }}" style="color:rgba(255,255,255,0.5)">Create account</a></p>
                                    </div>
                                    <!--end col-->
                                    
                                    <!--<div class="text-center col-12">-->
                                    <!--    <p class="mt-4 mb-0"><small class="mr-2 text-dark">&copy; Copyright  2024 &nbsp; Tesla Phantom Trades &nbsp; All Rights Reserved.</small>-->
                                    <!--    </p>-->
                                    <!--</div>-->
                                </form></div>
                                <!--end row-->
                            </form>
                        </div>
                    </div>
                    <!---->
                </div>
                <!--end col-->
            </div>
            <!--end row-->
        
        <!--end container-->
    </section>
    <!--end section-->








   

@endsection
